/*!======================================================================*\
|| #################################################################### ||
|| # vBulletin 4.0.6
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/
/**
This provides a number of function useful in managing CMS content.
*/

		var jsAction;
		var curr_SectId = false;
		var curr_parentcat = false;
		var curr_catid = false;
		
		var curr_nodeid = false;
		var submitAction;
		var hiddenDiv;

		/** This handles the JS to submit the cms edit page using "apply"
		so the user remains on the edit page.
		 **/
		function applyChanges(formname, submit_url)
		{
			//javascript:document.getElementById('do_editform').value='apply';
			form = document.getElementById(formname);
			if (form !== undefined)
			{
				form.action = submit_url;
				form.submit();
			}
		}

		/** This checks and unchecks a visual component after verifying that
		the object exists
		 **/
		function setChecked(checked, componentName)
		{
			if (document.getElementById(componentName) !== undefined)
			{
				document.getElementById(componentName).checked = checked;
			}
		}

		/** This updates the category display for an article edit page.
		* it returns no value, rather it refreshes the component.
		*
		* @param string Name of the div whose elements will be replaced.
		* @param string Name of the checklist element to be created.
		* @param string url of ajax.php
		* @param string type of request- category, section, string
		* @param mixed	 value matching the request type.
		**/
		function setCategoryList(divName, cbName, keyName, target, type, value, sorted)
		{

			//We need to have a div name and a component name or we can do nothing.
			//We also should verify that the div names must be valid
			if (divName == '' || cbName == '' || document.getElementById(divName) == undefined)
			{
				return;
			}

			params = '';

			if (target == '')
			{
				url = '../ajax.php';
			}
			else
			{
				url = target;
			}

			if (type == '')
			{
				type = 'all';
			}
			request = url + '?do=find_categories&type=' + type + '&name=' + cbName ;

			if (value != '')
			{
				request += '&value=' + value;
			}

			if (sorted)
			{
				request += '&sort=1';
			}

			categoryKeys = document.getElementsByName(keyName);
			postdata = '';
			for (catid in categoryKeys)
			{
				checkBox = document.getElementById(cbName + '_' + catid);
				if ((checkBox != undefined) && checkBox.checked)
				{
					postdata += 'checkedcat[]=' + catid + '&';
		}
			}

			load_html(divName, request, postdata, null, null);
		}


		/**
		 *
		 * This checks to see if there is a title and URL set.
		 * @return void
		 **/
		function checkTitles(title_msg, url_msg)
		{
			msg = '';

			if (document.getElementById('cms_node_title') != undefined)
			{
				if (document.getElementById('cms_node_title').value.length < 3)
				{
					msg = title_msg + '  ';
				}
			}

			if (document.getElementById('cms_node_url') != undefined)
			{
				if (document.getElementById('cms_node_url').value.length < 3)
				{
					msg = msg + url_msg;
				}
			}

			if (msg != '')
			{
				alert(msg);
				return false;
			}
			return true;
		}

		//We have three different functions- copy, move, and delete- which we can't do until
		// the user selects a target node. We have a nodepanel div that can be displayed when
		// we are ready to do one of these functions. We could make three different div's, but better
		// is to set a flag and make the appropriate action when the user clicks. This is the flag

		function setFormValue(name, value)
		{
			if (document.getElementById(name) != undefined)
			{
				document.getElementById(name).value = value;
			}
			else
			{
				var newHidden = document.createElement('input');
				newHidden.type = 'hidden';
				newHidden.name = name;
				newHidden.id = name;
				newHidden.value = value;
				document.getElementById('cms_data').appendChild(newHidden);
			}

		}

		function searchNodes( location, formid )
		{
			if (location == undefined)
			{
				location = '.';
			}

			url = location + '/ajax.php?do=find_leaves';
			if (document.getElementById('contenttypeid') != undefined && document.getElementById('contenttypeid').value != '')
			{
			url = url + '&contenttypeid=' + document.getElementById('contenttypeid').value + '&formid=' +  encodeURI(formid);
			}

			if (document.getElementById('title_filter') != undefined && document.getElementById('title_filter').value != '')
			{
				url = url + '&title_filter=' + encodeURI(document.getElementById('title_filter').value);
			}

			if (document.getElementById('state_filter') != undefined && document.getElementById('state_filter').value != '')
			{
				url = url + '&state_filter=' + document.getElementById('state_filter').value;
			}

			if (document.getElementById('author_filter') != undefined && document.getElementById('author_filter').value != '')
			{
				url = url + '&author_filter=' + document.getElementById('author_filter').value;
			}

			load_html('search_results', url,
				'', null, null);
		}


		function flagCategory(id)
		{
			if (id == undefined)
			{
				id = curr_parentcat;
			}

			if (parseInt(id) < 1)
			{
				YAHOO.util.Dom.setStyle(document.getElementById('catchecked_img_0'), "display", "");
			}
			else
			{
				YAHOO.util.Dom.setStyle(document.getElementById('catchecked_img_0'), "display", "none");
			}
			i = 1;
			while (document.getElementById('catedit_id_' + i) != undefined)
			{
				var category_image = document.getElementById('catchecked_img_' + i);

				if (document.getElementById('catedit_id_' + i).value == id)
				{
					YAHOO.util.Dom.setStyle(category_image, "display", "");
				}
				else
				{
					YAHOO.util.Dom.setStyle(category_image, "display", "none");
				}
				i++;

			}
			if  (document.getElementById('target_categoryid') != undefined)
			{
				document.getElementById('target_categoryid').value = id;
			}
		}
		function flagSection(id)
		{
			if ('filter' == submitAction)
			{
				document.getElementById('sectionid').value = id;
				document.getElementById('cms_data').submit();
			}

			i = 1;

			while (document.getElementById('sectedit_id_' + i) != undefined)
			{
				if (document.getElementById('sectedit_id_' + i).value == id)
				{
					document.getElementById('sectchecked_img_' + i).style.display = 'inline';
					YAHOO.util.Dom.addClass('sectchecked_ul_' + i, 'section_row');
				}
				else
				{
					document.getElementById('sectchecked_img_' + i).style.display = 'none';
					YAHOO.util.Dom.removeClass('sectchecked_ul_' + i, 'section_row');
				}
				i++;
			}

			if  (document.getElementById('target_categoryid') != undefined)
			{
				document.getElementById('target_categoryid').value = false;
			}
		}

		//This gets called if the user selects a node. Depending on jsAction we could
		// do one of several things.
		function setSection(id, name, categoryid)
		{
			if (categoryid == undefined)
			{
				categoryid = -1;
			}

			if (jsAction == 'move_section' || jsAction == 'publish_section' || jsAction == 'unpublish_section'	|| jsAction == 'move_node' || jsAction == 'publish_node' || jsAction == 'unpublish_node'	|| jsAction == 'new' || jsAction == 'filter_category'|| jsAction == 'filter_section' || jsAction == 'filter_nodesection')
			{
				document.getElementById('sectionid').value = id;
				document.getElementById('do').value = jsAction;

				document.getElementById('cms_data').submit();
			}
			else if (jsAction == 'new_section' || jsAction == 'save_section' )
			{
				setFormValue('target_sectionid', id);
				return false;
			}
			else if (jsAction == 'doCategory')
				{
				//first we turn on the checkbox for only the checked item;
				flagSection(id);
				document.getElementById('catedit_category_list').style.display = 'block';
				document.getElementById('catedit_category_list').style.width = '339px';
				setFormValue('sectionid', id);
				setFormValue('curr_SectId', id);
				curr_parentcat = categoryid;
				load_html('catedit_category_list', script_location + '/ajax.php?do=list_categories&sectionid=' + id,
				'', null, flagCategory);
				}
			else if (jsAction == 'doSection')
				{
				//first we turn on the checkbox for only the checked item;
				flagSection(id);
				setFormValue('target_sectionid', id);
				setFormValue('sectionid', curr_SectId);

				}
			else
			{
				if (document.getElementById('sectionName') != undefined)
				{
					document.getElementById('sectionName').innerHTML = name;
				}
				if (document.getElementById('sectionid') != undefined)
				{
					document.getElementById('sectionid').value = id;
				}
				document.getElementById('catedit_category_list').style.display = 'none';
				return false;
			}
		}

		/** This checks to see if a forms values have changed, and submits
		 * after checking (if necessary) for a confirmation.
		 *
		 * @param formname	name of the form to check
		 * @param componentname	name of the component from which we are called. We don't check
		 *	its value
		 * @param confirmstring	a confirmation string
		 **/
		function checkShouldSave(formname, componentname, confirmation, submiturl)
		{
			form = document.getElementById(formname);
			//make sure we have a valid form
			if (form === undefined)
			{
				return false;
			}

			//if it hasn't changed, just submit.
			if (!checkFormChanged(formname, componentname))
			{
				if (submiturl !== '')
				{
					form.action = submiturl;
				}
				form.submit();
				return true;
			}
			//get a confirmation
			if (confirm(confirmation))
			{
				if (submiturl !== '')
				{
					form.action = submiturl;
				}
				form.submit();
			}
			return false;
		}

		/** This checks a form variable to see if any elements have changed
		 *
		 * @param formname	name of the form to check
		 * @param componentname	name of the component from which we are called. We don't check
		 *	its value

		 * @return bool
		 **/
		function checkFormChanged(formname, componentname)
		{
			form = document.getElementById(formname);
			//make sure we have a valid form
			if (form === undefined)
			{
				return false;
			}
			//scan the form elements
			for (var i=0; i < form.elements.length; i++)
			{
				element = form.elements[i];
				//If we have a select list we need to check each option.
				if (element.name != componentname)
				{
					if (element.options !== undefined)
					{
						//If nothing was initially selected, the first value
						//will be selected. So we can skip that one.
						option_selected = false;
						for (var j = 1 ; j < element.options.length; j++)
						{
							option = element.options[j];
							if (option.selected != option.defaultSelected)
							{
								return true;
							}
						}
					}
					//If it's another type we could have value or checked.
					else
					{
						if (element.defaultChecked !== '')
						{
							if (element.defaultChecked != element.checked)
							{
								return true;
							}
						}
						else if (element.defaultValue !== undefined)
						{
							if (element.defaultValue != element.value)
							{
								return true;
							}
						}
					}
				}
			}
			//if we got here, nothing has changed
			return false;
		}

		function showCatEdit(action, sectionid, categoryid, title, section_caption, parentcat)
		{
			//If we set the \"new\" submitAction before we flag category and
			// section, we'll auto-submit ourselves.

			var catPickerInterface = document.getElementById("title_editor");
			var isNewTopLevelCategory = ((sectionid == -1) && (categoryid == -1));
			var categorySelector = document.getElementById("category_selector");
			var currentSectionElement = document.getElementById("sectionid");
			var catedit_category_list = document.getElementById("catedit_category_list");
			var titleControls = document.getElementById("category_title_controls");
			var sectionControls = document.getElementById("section_picker_controls");

			/*
				-ch: note: acting on style.visibility vs style.display
				ensures relevant form elements still remain part of the DOM
				at the time the backing <form> gets submitted.
			*/
			if (section_caption != '')
			{
				document.getElementById('section_tab').innerHTML = section_caption;
			}

			submitAction = '';
			jsAction = 'doCategory';
			curr_catid = categoryid;
			curr_SectId = sectionid;

			if (action == "filter")
			{
			//If the category was edited and cancelled, then we need to reload
			// the section list. Let's just do it.

				url = location + '/ajax.php?do=list_nodes';
				load_html('title_editor', url,
					'', null, null);

				YAHOO.util.Dom.setStyle(titleControls, "display", "none");
				sectionControls.style.visibility = "visible";
				YAHOO.util.Dom.setStyle(categorySelector, "display", "none");
				YAHOO.util.Dom.setStyle(catPickerInterface, "width", "350px");
				YAHOO.util.Dom.setStyle(catedit_category_list, "display", "none");
			//	catPickerInterface.style.height = "450px";
			}
			else
			{
				YAHOO.util.Dom.setStyle(titleControls, "display", "");
				YAHOO.util.Dom.setStyle(catPickerInterface, "width", "700px");
				YAHOO.util.Dom.setStyle(categorySelector, "display", "");
				YAHOO.util.Dom.setStyle(catedit_category_list, "display", "");

				if ((action == "new") && isNewTopLevelCategory) {
					sectionControls.style.visibility = "visible";
					catPickerInterface.style.visibility = "visible";
				}
				else
				{
					sectionControls.style.visibility = "visible";
					document.getElementById('catedit_category_list').style.visibility = "visible";
				}
				setSection(sectionid, section_caption, parentcat);
			}

			document.getElementById('title_editor').style.display = 'block';
			document.getElementById('categoryid').value = -1;
			document.getElementById('category_title').value = title;
			submitAction = action;
		}

		function showSectionEdit(action, sectionid, nodeid, title)
		{
			//If we set the \"new\" submitAction before we flag category and
			// section, we'll auto-submit ourselves.
			submitAction = '';
			jsAction = 'doSection';
			document.getElementById('title_editor').style.display = 'block';

			var region = YAHOO.util.Dom.getRegion("title_editor");
			var iframe = YAHOO.util.Dom.get("iframeie6die");
			if (iframe)
			{
				YAHOO.util.Dom.setStyle(iframe, "top", region.top + "px");
				YAHOO.util.Dom.setStyle(iframe, "width", region.width + "px");
				YAHOO.util.Dom.setStyle(iframe, "height", region.height + "px");
				YAHOO.util.Dom.setStyle(iframe, "right", region.right + "px");
				YAHOO.util.Dom.setStyle(iframe, "left", region.left + "px");
				YAHOO.util.Dom.setStyle(iframe, "display", "block");
			}

			document.getElementById('sectionid').value = -1;
			document.getElementById('section_title').value = title;
			curr_nodeid = nodeid;
			curr_SectId = sectionid;
			if ('new_section' == action)
			{
				flagSection(nodeid);
			}
			else
			{
				flagSection(sectionid);
			}
			submitAction = action;
			}

		//This is called when we change the order in the content manager dropdown
		function setOrder(id, sectionid, value)
		{
			document.getElementById('do').value	= 'set_order';
			setFormValue('id', id);
			setFormValue('sectionid', sectionid);
			setFormValue('displayorder', value);
			document.getElementById('cms_data').submit();
		}

		function confirmCategoryDelete(categoryid, confirm_phrase)
		{
			if (categoryid)
			{
				if (confirm(confirm_phrase))
				{
					document.getElementById('categoryid').value = categoryid;
					document.getElementById('do').value = 'delete_category';
					document.getElementById('cms_data').submit();
				}
			}
		}

		function confirmSectionDelete(sectionid, confirm_phrase)
		{
			if (sectionid)
			{
				if (confirm(confirm_phrase))
				{
					setFormValue('delete_sectionid', sectionid);
					document.getElementById('do').value = 'delete_section';
					document.getElementById('cms_data').submit();
				}
			}
		}
		//This function is the handler for the category editor
		function setCategory(prompt_NeedCategory, prompt_NeedsectionOrCategory)
		{
			document.getElementById('category_title').value = PHP.trim(document.getElementById('category_title').value);

			if ('' == document.getElementById('category_title').value)
			{
				alert(prompt_NeedCategory);
				return;
			}

			document.getElementById('title').value = document.getElementById('category_title').value;
			if ('edit' == submitAction)
			{
				document.getElementById('categoryid').value = curr_catid;
				document.getElementById('do').value = 'save_category';
				document.getElementById('cms_data').submit();
			}
			if ('new' == submitAction)
			{
				if (! (parseInt(curr_catid) > 0 || parseInt(document.getElementById('sectionid').value) > 0))
				{
					alert(prompt_NeedsectionOrCategory);
					return;
				}

				if (curr_catid)
				{
					setFormValue('categoryid', curr_catid);
				}
				setFormValue('do', 'new_category');
				document.getElementById('cms_data').submit();
			}
		}


		//This function is the handler for the section editor
		function setEditedSection(prompt_phrase)
		{

			document.getElementById('section_title').value = PHP.trim(document.getElementById('section_title').value);

			if ('' == document.getElementById('section_title').value)
			{
				alert(prompt_phrase);
				return;
			}

			setFormValue('title',document.getElementById('section_title').value);
			setFormValue('sectionid', curr_SectId);
			setFormValue('nodeid', curr_nodeid);
			document.getElementById('do').value = submitAction;
			document.getElementById('cms_data').submit();
		}

		function swapSections(node1, node2)
		{
			setFormValue('nodeid', node1);
			setFormValue('nodeid2', node2);
			document.getElementById('do').value = 'swap_sections';
			document.getElementById('cms_data').submit();
		}

		function setCategoryView()
		{
				document.getElementById('catedit_section_list').style.display = 'none';
				document.getElementById('catedit_category_list').style.display='block';
				document.getElementById('section_tab').style.backgroundColor='#ffffff';
				document.getElementById('category_tab').style.backgroundColor='#bbbbbb';
		}

		function setSectionView()
		{
			document.getElementById('catedit_section_list').style.display='block';
			document.getElementById('catedit_category_list').style.display='none';
			document.getElementById('section_tab').style.backgroundColor='#bbbbbb';
			document.getElementById('category_tab').style.backgroundColor='#ffffff';
		}

		function clearSectionFlags()
		{
			i = 1;
			while (document.getElementById('sectedit_id_' + i) != undefined)
			{
				document.getElementById('sectchecked_img_' + i).style.display = 'none';
				i++;
			}
		}




		function getSectionList( order)
		{
			load_html('cms_sections_list',
				script_location + '/ajax.php?do=list_allsection&order=' + order, '', null, null);
		}

		//This displays the window we use to select a node for searching.
		function showNodeWindow(thisAction)
		{
			jsAction = thisAction;
			document.getElementById('sel_node_0').style.display = 'block';
			document.getElementById('sel_node_0').focus();
			var region = YAHOO.util.Dom.getRegion("sel_node_0");
			var iframe = YAHOO.util.Dom.get("iframeie6die");
			if (iframe)
			{
				YAHOO.util.Dom.setStyle(iframe, "top", region.top + "px");
				YAHOO.util.Dom.setStyle(iframe, "width", region.width + "px");
				YAHOO.util.Dom.setStyle(iframe, "height", region.height + "px");
				YAHOO.util.Dom.setStyle(iframe, "right", region.right + "px");
				YAHOO.util.Dom.setStyle(iframe, "left", region.left + "px");
				YAHOO.util.Dom.setStyle(iframe, "display", "block");
			}

			if (document.getElementById('title_filter') != undefined && document.getElementById('title_filter').value != '')
			{
				document.getElementById('title_filter').value = '';
			}

			if (document.getElementById('section_search_button') != undefined)
			{
				document.getElementById('section_search_button').click();
			}
		}


		function deleteGrouping(type, confirm_phrase)
		{
			if (confirm(confirm_phrase))
			{
				document.getElementById('do').value = 'delete_' + type;
				document.getElementById('cms_data').submit();
			}
			else
			{
				return false;
			}
		}



		//This resets the search fields when the user clicks the \"clear\" button
		function clearSearch()
		{
			if (document.getElementById('state_filter') != undefined)
			{
				document.getElementById('state_filter').selectedIndex = -1;
			}

			if (document.getElementById('title_filter') != undefined)
			{
				document.getElementById('title_filter').value = '';
			}

			if (document.getElementById('author_filter') != undefined)
			{
				document.getElementById('author_filter').selectedIndex = -1;
			}

			if (document.getElementById('contenttypeid') != undefined)
			{
				document.getElementById('contenttypeid').selectedIndex = -1;
			}

		}

		//This expands or hides the display of subsections
		// below a selected node.
		function toggleSubSection(section_id, level, remoteUrlParam )
		{
			if (parseInt(section_id) > 0 &&
				document.getElementById('sect_toggle_' + section_id) != undefined)
			{
				sect_body = document.getElementById('detail_list').tBodies[0];

				if (document.getElementById('sect_toggle_' + section_id).innerHTML == ' -')
				{
					//This means that we have already populated the children
					//We have to change the display to a plus and hide them.
					// So what we need to do is:
					// Look for the record that has the section_id in the first cell. Record its
					// level.
					// Look in the next row. Its level should be one higher than the recorded level.
					// If so, remove every cell until level returns to the recorded level or we get
					// to the end.
					document.getElementById('sect_toggle_' + section_id).innerHTML = ' +';

					for (i = sect_body.rows.length - 1; i >0; i--)
					{
						if (parseInt(sect_body.rows[i].cells[0].innerHTML) == section_id)
						{
							//We found it.
							//if we are at the last row, we don't need to check
							if (i < sect_body.rows.length - 2 )
							{
								parent_level = parseInt(sect_body.rows[i].cells[1].innerHTML);
								i++;
								this_level = parseInt(sect_body.rows[i].cells[1].innerHTML);
								if (this_level == parent_level + 1)
								{
									while ( (i < sect_body.rows.length ) && parseInt(sect_body.rows[i].cells[1].innerHTML) > parent_level)
									{
										//sect_body.rows[i].style.display = 'none';
										sect_body.deleteRow(i);
									}
								}
								break;
							}
						}
					}
				}
				else
				{
					//we may have already populated the children. If so we just need
					// to display them.
					foundit = false;
					for (i = 1; i < sect_body.rows.length; i++)
					{
						if (sect_body.rows[i].cells[0].innerHTML == section_id &&
							i < sect_body.rows.length - 2 )
						{
							//We found it.
							parent_level = parseInt(sect_body.rows[i].cells[1].innerHTML);
							i++;
							this_level = parseInt(sect_body.rows[i].cells[1].innerHTML);
							if (this_level == parent_level + 1)
							{
								while ( (i < sect_body.rows[i].length) && parseInt(sect_body.rows[i].cells[1].innerHTML) >  parent_level)
								{
									sect_body.rows[i].style.display = 'block';
									i++;
								}
							}
							break;
						}
					}

					//Now if we didn't find a row with this parent we need to request a
					// ajax load.
					if (foundit)
					{
						document.getElementById('sect_toggle_' + section_id).innerHTML = ' -';
					}
					else
					{
						curr_SectId = section_id;
						load_html('hidden_content', script_location + '/ajax.php?do=' + remoteUrlParam
							+ section_id + '&level=' + level,
							'', null, addSections);
						document.getElementById('sect_toggle_' + section_id).innerHTML = ' -';
					}
				}
			}
			return false;
		}


		/** This makes an ajax call to see if an url is available.
		 * if not, it gives an error message
		 **/
		function checkUrlAvailable(urlEdit, divHidden, nodeid)
		{
			if (urlEdit != undefined)
			{
				hiddenDiv = divHidden;
				hiddenDiv.innerHTML = '';
				load_html(hiddenDiv, getBaseUrl() + '/ajax.php?do=checkurl',
				'url=' + urlEdit.value + '&nodeid=' + nodeid, null, showDupUrl);
			}

		}


		function showDupUrl()
		{
			if (document.getElementById(hiddenDiv).innerHTML != '')
			{
				alert(document.getElementById(hiddenDiv).innerHTML);
			}

		}
		//Needs explanation. The ajax call puts a series of table rows into the hidden
		// div. That's just a placeholder. We pull these out of that table and put
		// them into the visible table. We know where we need to put the new
		// content by looking in the second cell. The first cell is the id,
		// and the second is the level.
		// We have the Section we're looking to expand in curr_SectId.
		function addSections()
		{
			if (document.getElementById('hidden_content') != undefined )
			{
				xfr_body = document.getElementById('sect_xfer').tBodies[0];
				sect_body = document.getElementById('detail_list').tBodies[0];
				for (var i = 1; i < sect_body.rows.length; i++)
				{
					if (sect_body.rows[i].cells[0].innerHTML == curr_SectId)
					{
						//We found the record we want to expand.

						for (j = 0; j <  xfr_body.rows.length ; j++)
						{
							//first create the row and put it into the table.
							//var newrow = document.getElementById('detail_list').InsertRow(i + 1);
							var newrow = sect_body.insertRow(i + j + 1);
							newrow.innerHTML = xfr_body.rows[j].innerHTML;
						}
						document.getElementById('sect_toggle_' + curr_SectId).innerHTML = ' -';
						break;
					}
				}
			}
			//we don't need the hidden content any more. Might as well flush it.
			if (document.getElementById('hidden_content') != undefined)
			{
				document.getElementById('hidden_content').innerHTML = '';
			}
		}

	function makeSEOUrl(strSource, replacedest, copydest)
	{
		var pattern = /[\s$+,\/:=\?@"\'<>%{}|\\^~[\]`\r\n\t\x00-\x1f\x7f]/g;
		document.getElementById(replacedest).value = strSource.replace(pattern, "-").replace(/(-+)/gi, "-").replace(/(^-|-$)/gi, "");
		document.getElementById(copydest).value = strSource;
	}

	function toggleCheckBox(idPre, idPost, unitCount, val)
	{
		for (unitId=1; unitId<=unitCount; unitId++)
		{
			switch (val)
			{
				case '-1':
					document.getElementById(idPre + '_' + idPost + '_' + unitId.toString()).checked = !document.getElementById(idPre + '_' + idPost + '_' + unitId.toString()).checked;
					break;
				case '0':
					document.getElementById(idPre + '_' + idPost + '_' + unitId.toString()).checked = false;
					break;
				case '1':
					document.getElementById(idPre + '_' + idPost + '_' + unitId.toString()).checked = true;
					break;
				default:
					break;
			}
		}
	}